#include "string.h"
#include "AudioStack/clStack.h"
#include "AudioStack/clDiagStack.h"

#include "AudioStack/SMT/clSrcState.h"
#include "AudioStack/AudioSources/clAudioSourceController.h"
#include "AudioStack/clAudioSMEngine.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clDiagStack.cpp.trc.h"
#endif

namespace AudioStack
{
using namespace AudioSource;
clDiagStack::clDiagStack(int sinkID, const char* myName) :
  clStack(sinkID, myName)
{
  ETG_TRACE_USR4(("clDiagStack::clDiagStack(sinkID %d, name %s)",sinkID,myName));
}

clDiagStack::clDiagStack() :
  clStack()
{
  ETG_TRACE_USR4(("clDiagStack::clDiagStack()"));
}

clDiagStack::~clDiagStack()
{
  ETG_TRACE_USR4(("clDiagStack::~clDiagStack()"));
}

//virtual
clAudioSource* clDiagStack::AllowSource(clAudioSource &newSrc)
{
  SourceID newSrcID = newSrc.sGetId();
  ETG_TRACE_USR4(("clDiagStack::AllowSource ID.SubID = %d.%d always allowed"
      ,newSrcID.enSourceClass
      ,newSrcID.u16SubSource));

  return &newSrc;
}

} //namespace
